/***************************************************************************
                          main.c  -  description
                             -------------------
    begin                : Tue Jun 13 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "math.h"
#include "def.h"             
#include "main.h"
#include "serial.h"

//
//===========================================================================
//
//
//      Test Driver for Berkshire Serial Watchdog
//
//===========================================================================
//
//      Date  Ver.  Description
// ---------- ----- ---------------------------------------------
// 1998 08-28 0.99a First version started
//
//
char title[]   = {
          " Berkshire Serial Watchdog Test Program\n"
          " Berkshire Products - PO Box 1015 - Suwanee, GA 30024  USA\n"
          " www.berkprod.com  770-271-0088  FAX: 770-932-0082\n"
                 } ;
char version[] = {" Version 0.99a - 08/28/98\n\n"} ;
//
//

char *usage[] = {
"\n ** Command Line Options **\n\n",
" [/p#] - # = 1 to 4 for COM ports (default: COM1).\n" , 
NULL
} ;

// --------------------- Function Defs ------------------------------------

void ErrorBeep(void)     ;
void GoodBeep(void) ;
void PrintUsage(void)    ;
char *progname;


// *********************************************
//     MAIN
// *********************************************
int main(int argc, char *argv[])
{
       int   i , fd;
       char *device = NULL;
       UINT  iInput ;
       //clrscr() ;   
       printf(title) ;
       printf(version) ;
       progname = strrchr(argv[0], '/');
       if (progname == NULL)
           progname = argv[0];
       else
           progname++; 
       if (argc > 1)
           if (argv[1] != NULL)
               device = argv[1];
       if(test_serial(device) < 0)
       {
         ErrorBeep() ;
         printf("\nUnable to open: %s\n", device) ;
         exit(2) ;
       }
       while(1)
       {
         iInput = 0 ;
         printf("Enter 0 to Exit or Watchdog Command (0x20-0xFF): ") ;
         scanf("%2X", &iInput) ;
         printf("\n") ;
         if(iInput == 0)
           break ;
         if(iInput < 0x20) 
         {
           ErrorBeep() ;
           printf("Input must be between 0x20 and 0xFF!\n") ;
         }
         else
         {
           if((i = wd_cmd(device, iInput)) > 0)   // wait 200mS for Rx
           {
             GoodBeep() ;
             printf("Watchdog said: 0x%02X = %3d Decimal\n", i, i) ;
             if(i == ACK)
               printf(" *** ACK ***\n") ;
             if(i == NAK1)
               printf(" *** NAK1 ***\n") ;
             if(i == NAK2)
               printf(" *** NAK2 ***\n") ;
             if((i >= 0x20)&&(iInput == 0x58))
               printf("\nAmbient Temparature is %d Celsius - %d Fahrenheit\n",i-0x40,(i-0x40)*9/5+32); 
             if((i >= 0x20)&&(iInput != 0x58))
               printf("\nValue > 0x20 is Response: 0x%02X = %3d Dec\n", i-0x20, i-0x20) ;
           }
           else
           {
             ErrorBeep() ;
             printf("Receive Error: %d\n", i) ;
           }
         }
       }
       exit(0) ;
}

// ---------------------------------------------------------------------
//   Print Usage Instructions 
// ---------------------------------------------------------------------
void PrintUsage(void)
{
     int i ;

     i = 0 ;
     while(usage[i] != NULL)
     {
       printf(usage[i]) ;
       i++ ;
     }
}

/*************************************

     Misc beeps (not functional at this time)

**************************************/
void ErrorBeep(void)
{

     //sound(440)  ;
     //delay(300) ;
     //nosound()   ;
}

void GoodBeep(void)
{
     //sound(920)  ;
     //delay(160) ;
     //nosound()   ;
}                 

